<?php

/////////////////////////////////////
// Theme Setup
/////////////////////////////////////

if ( ! function_exists( 'mvp_setup' ) ) {
function mvp_setup(){
	load_theme_textdomain('zox-news', get_template_directory() . '/languages');

	$locale = get_locale();
	$locale_file = get_template_directory() . "/languages/$locale.php";
	if ( is_readable( $locale_file ) )
		require_once( $locale_file );
	add_theme_support( 'post-formats', array( 'gallery', 'video' ) );

}
}
add_action('after_setup_theme', 'mvp_setup');

/////////////////////////////////////
// Theme Options
/////////////////////////////////////

require_once get_template_directory() . '/admin/admin-functions.php';
require_once get_template_directory() . '/admin/admin-interface.php';
require_once get_template_directory() . '/admin/theme-settings.php';

if ( !function_exists( 'mvp_fonts_url' ) ) {
function mvp_fonts_url() {

$mvp_featured_font = get_option('mvp_featured_font');
$mvp_title_font = get_option('mvp_title_font');
$mvp_heading_font = get_option('mvp_heading_font');
$mvp_content_font = get_option('mvp_content_font');
$mvp_para_font = get_option('mvp_para_font');
$mvp_menu_font = get_option('mvp_menu_font');
$font_url = '';

    if ( 'off' !== _x( 'on', 'Google font: on or off', 'zox-news' ) ) {
        $font_url = add_query_arg( 'family', urlencode( 'Advent Pro:700&subset=latin,latin-ext,cyrillic,cyrillic-ext,greek-ext,greek,vietnamese|Open Sans:700&subset=latin,latin-ext,cyrillic,cyrillic-ext,greek-ext,greek,vietnamese|Anton:400&subset=latin,latin-ext,cyrillic,cyrillic-ext,greek-ext,greek,vietnamese|' .  $mvp_featured_font . ':100,200,300,400,500,600,700,800,900&subset=latin,latin-ext,cyrillic,cyrillic-ext,greek-ext,greek,vietnamese|' .  $mvp_title_font . ':100,200,300,400,500,600,700,800,900&subset=latin,latin-ext,cyrillic,cyrillic-ext,greek-ext,greek,vietnamese|' .  $mvp_heading_font . ':100,200,300,400,500,600,700,800,900&subset=latin,latin-ext,cyrillic,cyrillic-ext,greek-ext,greek,vietnamese|' .  $mvp_content_font . ':100,200,300,400,500,600,700,800,900&subset=latin,latin-ext,cyrillic,cyrillic-ext,greek-ext,greek,vietnamese|' .  $mvp_para_font . ':100,200,300,400,500,600,700,800,900&subset=latin,latin-ext,cyrillic,cyrillic-ext,greek-ext,greek,vietnamese|' .  $mvp_menu_font . ':100,200,300,400,500,600,700,800,900&subset=latin,latin-ext,cyrillic,cyrillic-ext,greek-ext,greek,vietnamese' ), "//fonts.googleapis.com/css" );
    }
    return $font_url;
}
}

if ( !function_exists( 'mvp_styles_method' ) ) {
function mvp_styles_method() {
    wp_enqueue_style(
        'mvp-custom-style',
        get_stylesheet_uri()
    );
	$wallad = get_option('mvp_wall_ad');
	$primarycolor = get_option('mvp_primary_color');
	$secondcolor = get_option('mvp_second_color');
	$topnavbg = get_option('mvp_top_nav_bg');
	$topnavtext = get_option('mvp_top_nav_text');
	$topnavhover = get_option('mvp_top_nav_hover');
	$botnavbg = get_option('mvp_bot_nav_bg');
	$botnavtext = get_option('mvp_bot_nav_text');
	$botnavhover = get_option('mvp_bot_nav_hover');
	$link = get_option('mvp_link_color');
	$link2 = get_option('mvp_link2_color');
	$featured_font = get_option('mvp_featured_font');
	$title_font = get_option('mvp_title_font');
	$heading_font = get_option('mvp_heading_font');
	$content_font = get_option('mvp_content_font');
	$para_font = get_option('mvp_para_font');
	$menu_font = get_option('mvp_menu_font');
	$mvp_customcss = get_option('mvp_customcss');
        $mvp_theme_options = "

#mvp-wallpaper {
	background: url($wallad) no-repeat 50% 0;
	}

#mvp-foot-copy a {
	color: $link;
	}

#mvp-content-main p a,
.mvp-post-add-main p a {
	box-shadow: inset 0 -4px 0 $link;
	}

#mvp-content-main p a:hover,
.mvp-post-add-main p a:hover {
	background: $link;
	}

a,
a:visited,
.post-info-name a,
.woocommerce .woocommerce-breadcrumb a {
	color: $link2;
	}

#mvp-side-wrap a:hover {
	color: $link2;
	}

.mvp-fly-top:hover,
.mvp-vid-box-wrap,
ul.mvp-soc-mob-list li.mvp-soc-mob-com {
	background: $primarycolor;
	}

nav.mvp-fly-nav-menu ul li.menu-item-has-children:after,
.mvp-feat1-left-wrap span.mvp-cd-cat,
.mvp-widget-feat1-top-story span.mvp-cd-cat,
.mvp-widget-feat2-left-cont span.mvp-cd-cat,
.mvp-widget-dark-feat span.mvp-cd-cat,
.mvp-widget-dark-sub span.mvp-cd-cat,
.mvp-vid-wide-text span.mvp-cd-cat,
.mvp-feat2-top-text span.mvp-cd-cat,
.mvp-feat3-main-story span.mvp-cd-cat,
.mvp-feat3-sub-text span.mvp-cd-cat,
.mvp-feat4-main-text span.mvp-cd-cat,
.woocommerce-message:before,
.woocommerce-info:before,
.woocommerce-message:before {
	color: $primarycolor;
	}

#searchform input,
.mvp-authors-name {
	border-bottom: 1px solid $primarycolor;
	}

.mvp-fly-top:hover {
	border-top: 1px solid $primarycolor;
	border-left: 1px solid $primarycolor;
	border-bottom: 1px solid $primarycolor;
	}

.woocommerce .widget_price_filter .ui-slider .ui-slider-handle,
.woocommerce #respond input#submit.alt,
.woocommerce a.button.alt,
.woocommerce button.button.alt,
.woocommerce input.button.alt,
.woocommerce #respond input#submit.alt:hover,
.woocommerce a.button.alt:hover,
.woocommerce button.button.alt:hover,
.woocommerce input.button.alt:hover {
	background-color: $primarycolor;
	}

.woocommerce-error,
.woocommerce-info,
.woocommerce-message {
	border-top-color: $primarycolor;
	}

ul.mvp-feat1-list-buts li.active span.mvp-feat1-list-but,
span.mvp-widget-home-title,
span.mvp-post-cat,
span.mvp-feat1-pop-head {
	background: $secondcolor;
	}

.woocommerce span.onsale {
	background-color: $secondcolor;
	}

.mvp-widget-feat2-side-more-but,
.woocommerce .star-rating span:before,
span.mvp-prev-next-label,
.mvp-cat-date-wrap .sticky {
	color: $secondcolor !important;
	}

#mvp-main-nav-top,
#mvp-fly-wrap,
.mvp-soc-mob-right,
#mvp-main-nav-small-cont {
	background: $topnavbg;
	}

#mvp-main-nav-small .mvp-fly-but-wrap span,
#mvp-main-nav-small .mvp-search-but-wrap span,
.mvp-nav-top-left .mvp-fly-but-wrap span,
#mvp-fly-wrap .mvp-fly-but-wrap span {
	background: $topnavtext;
	}

.mvp-nav-top-right .mvp-nav-search-but,
span.mvp-fly-soc-head,
.mvp-soc-mob-right i,
#mvp-main-nav-small span.mvp-nav-search-but,
#mvp-main-nav-small .mvp-nav-menu ul li a  {
	color: $topnavtext;
	}

#mvp-main-nav-small .mvp-nav-menu ul li.menu-item-has-children a:after {
	border-color: $topnavtext transparent transparent transparent;
	}

#mvp-nav-top-wrap span.mvp-nav-search-but:hover,
#mvp-main-nav-small span.mvp-nav-search-but:hover {
	color: $topnavhover;
	}

#mvp-nav-top-wrap .mvp-fly-but-wrap:hover span,
#mvp-main-nav-small .mvp-fly-but-wrap:hover span,
span.mvp-woo-cart-num:hover {
	background: $topnavhover;
	}

#mvp-main-nav-bot-cont {
	background: $botnavbg;
	}

#mvp-nav-bot-wrap .mvp-fly-but-wrap span,
#mvp-nav-bot-wrap .mvp-search-but-wrap span {
	background: $botnavtext;
	}

#mvp-nav-bot-wrap span.mvp-nav-search-but,
#mvp-nav-bot-wrap .mvp-nav-menu ul li a {
	color: $botnavtext;
	}

#mvp-nav-bot-wrap .mvp-nav-menu ul li.menu-item-has-children a:after {
	border-color: $botnavtext transparent transparent transparent;
	}

.mvp-nav-menu ul li:hover a {
	border-bottom: 5px solid $botnavhover;
	}

#mvp-nav-bot-wrap .mvp-fly-but-wrap:hover span {
	background: $botnavhover;
	}

#mvp-nav-bot-wrap span.mvp-nav-search-but:hover {
	color: $botnavhover;
	}

body,
.mvp-feat1-feat-text p,
.mvp-feat2-top-text p,
.mvp-feat3-main-text p,
.mvp-feat3-sub-text p,
#searchform input,
.mvp-author-info-text,
span.mvp-post-excerpt,
.mvp-nav-menu ul li ul.sub-menu li a,
nav.mvp-fly-nav-menu ul li a,
.mvp-ad-label,
span.mvp-feat-caption,
.mvp-post-tags a,
.mvp-post-tags a:visited,
span.mvp-author-box-name a,
#mvp-author-box-text p,
.mvp-post-gallery-text p,
ul.mvp-soc-mob-list li span,
#comments,
h3#reply-title,
h2.comments,
#mvp-foot-copy p,
span.mvp-fly-soc-head,
.mvp-post-tags-header,
span.mvp-prev-next-label,
span.mvp-post-add-link-but,
#mvp-comments-button a,
#mvp-comments-button span.mvp-comment-but-text,
.woocommerce ul.product_list_widget span.product-title,
.woocommerce ul.product_list_widget li a,
.woocommerce #reviews #comments ol.commentlist li .comment-text p.meta,
.woocommerce div.product p.price,
.woocommerce div.product p.price ins,
.woocommerce div.product p.price del,
.woocommerce ul.products li.product .price del,
.woocommerce ul.products li.product .price ins,
.woocommerce ul.products li.product .price,
.woocommerce #respond input#submit,
.woocommerce a.button,
.woocommerce button.button,
.woocommerce input.button,
.woocommerce .widget_price_filter .price_slider_amount .button,
.woocommerce span.onsale,
.woocommerce-review-link,
#woo-content p.woocommerce-result-count,
.woocommerce div.product .woocommerce-tabs ul.tabs li a,
a.mvp-inf-more-but,
span.mvp-cont-read-but,
span.mvp-cd-cat,
span.mvp-cd-date,
.mvp-feat4-main-text p,
span.mvp-woo-cart-num,
span.mvp-widget-home-title2,
.wp-caption,
#mvp-content-main p.wp-caption-text,
.gallery-caption,
.mvp-post-add-main p.wp-caption-text,
#bbpress-forums,
#bbpress-forums p,
.protected-post-form input,
#mvp-feat6-text p {
	font-family: '$content_font', sans-serif;
	}

.mvp-blog-story-text p,
span.mvp-author-page-desc,
#mvp-404 p,
.mvp-widget-feat1-bot-text p,
.mvp-widget-feat2-left-text p,
.mvp-flex-story-text p,
.mvp-search-text p,
#mvp-content-main p,
.mvp-post-add-main p,
.rwp-summary,
.rwp-u-review__comment,
.mvp-feat5-mid-main-text p,
.mvp-feat5-small-main-text p {
	font-family: '$para_font', sans-serif;
	}

.mvp-nav-menu ul li a,
#mvp-foot-menu ul li a {
	font-family: '$menu_font', sans-serif;
	}


.mvp-feat1-sub-text h2,
.mvp-feat1-pop-text h2,
.mvp-feat1-list-text h2,
.mvp-widget-feat1-top-text h2,
.mvp-widget-feat1-bot-text h2,
.mvp-widget-dark-feat-text h2,
.mvp-widget-dark-sub-text h2,
.mvp-widget-feat2-left-text h2,
.mvp-widget-feat2-right-text h2,
.mvp-blog-story-text h2,
.mvp-flex-story-text h2,
.mvp-vid-wide-more-text p,
.mvp-prev-next-text p,
.mvp-related-text,
.mvp-post-more-text p,
h2.mvp-authors-latest a,
.mvp-feat2-bot-text h2,
.mvp-feat3-sub-text h2,
.mvp-feat3-main-text h2,
.mvp-feat4-main-text h2,
.mvp-feat5-text h2,
.mvp-feat5-mid-main-text h2,
.mvp-feat5-small-main-text h2,
.mvp-feat5-mid-sub-text h2,
#mvp-feat6-text h2 {
	font-family: '$featured_font', sans-serif;
	}

.mvp-feat2-top-text h2,
.mvp-feat1-feat-text h2,
h1.mvp-post-title,
h1.mvp-post-title-wide,
.mvp-drop-nav-title h4,
#mvp-content-main blockquote p,
.mvp-post-add-main blockquote p,
#mvp-404 h1,
#woo-content h1.page-title,
.woocommerce div.product .product_title,
.woocommerce ul.products li.product h3 {
	font-family: '$title_font', sans-serif;
	}

span.mvp-feat1-pop-head,
.mvp-feat1-pop-text:before,
span.mvp-feat1-list-but,
span.mvp-widget-home-title,
.mvp-widget-feat2-side-more,
span.mvp-post-cat,
span.mvp-page-head,
h1.mvp-author-top-head,
.mvp-authors-name,
#mvp-content-main h1,
#mvp-content-main h2,
#mvp-content-main h3,
#mvp-content-main h4,
#mvp-content-main h5,
#mvp-content-main h6,
.woocommerce .related h2,
.woocommerce div.product .woocommerce-tabs .panel h2,
.woocommerce div.product .product_title,
.mvp-feat5-side-list .mvp-feat1-list-img:after {
	font-family: '$heading_font', sans-serif;
	}

	";

	if(get_option('mvp_wall_ad')) {
	$mvp_wall_ad_css = "
	@media screen and (min-width: 1200px) {
	#mvp-site {
		float: none;
		margin: 0 auto;
		width: 1200px;
		}
	#mvp-leader-wrap {
		left: auto;
		width: 1200px;
		}
	.mvp-main-box {
		width: 1160px;
		}
	#mvp-main-nav-top,
	#mvp-main-nav-bot,
	#mvp-main-nav-small {
		width: 1200px;
		}
	}
		";
	}

	$mvp_site_skin = get_option('mvp_site_skin');
	if($mvp_site_skin == 'Entertainment') {
	$mvp_site_skin_css = "
	#mvp-main-nav-top {
		background: #fff;
		padding: 15px 0 0;
		}
	#mvp-fly-wrap,
	.mvp-soc-mob-right,
	#mvp-main-nav-small-cont {
		background: #fff;
		}
	#mvp-main-nav-small .mvp-fly-but-wrap span,
	#mvp-main-nav-small .mvp-search-but-wrap span,
	.mvp-nav-top-left .mvp-fly-but-wrap span,
	#mvp-fly-wrap .mvp-fly-but-wrap span {
		background: #000;
		}
	.mvp-nav-top-right .mvp-nav-search-but,
	span.mvp-fly-soc-head,
	.mvp-soc-mob-right i,
	#mvp-main-nav-small span.mvp-nav-search-but,
	#mvp-main-nav-small .mvp-nav-menu ul li a  {
		color: #000;
		}
	#mvp-main-nav-small .mvp-nav-menu ul li.menu-item-has-children a:after {
		border-color: #000 transparent transparent transparent;
		}
	.mvp-feat1-feat-text h2,
	h1.mvp-post-title,
	.mvp-feat2-top-text h2,
	.mvp-feat3-main-text h2,
	#mvp-content-main blockquote p,
	.mvp-post-add-main blockquote p {
		font-family: 'Anton', sans-serif;
		font-weight: 400;
		letter-spacing: normal;
		}
	.mvp-feat1-feat-text h2,
	.mvp-feat2-top-text h2,
	.mvp-feat3-main-text h2 {
		line-height: 1;
		text-transform: uppercase;
		}
		";
	}

	$mvp_nav_skin = get_option('mvp_nav_skin');
	$mvp_site_skin = get_option('mvp_site_skin');
	if($mvp_nav_skin == "Light" || $mvp_site_skin == "Entertainment") {
	$mvp_nav_skin_css = "
	span.mvp-nav-soc-but,
	ul.mvp-fly-soc-list li a,
	span.mvp-woo-cart-num {
		background: rgba(0,0,0,.8);
		}
	span.mvp-woo-cart-icon {
		color: rgba(0,0,0,.8);
		}
	nav.mvp-fly-nav-menu ul li,
	nav.mvp-fly-nav-menu ul li ul.sub-menu {
		border-top: 1px solid rgba(0,0,0,.1);
		}
	nav.mvp-fly-nav-menu ul li a {
		color: #000;
		}
	.mvp-drop-nav-title h4 {
		color: #000;
		}
		";
	}

	$mvp_nav_layout = get_option('mvp_nav_layout');
	if( $mvp_nav_layout == "Small" ) {
	$mvp_nav_layout_css = "
	#mvp-main-body-wrap {
		padding-top: 20px;
		}
	#mvp-feat2-wrap,
	#mvp-feat4-wrap,
	#mvp-post-feat-img-wide,
	#mvp-vid-wide-wrap {
		margin-top: -20px;
		}
	@media screen and (max-width: 479px) {
		#mvp-main-body-wrap {
			padding-top: 15px;
			}
		#mvp-feat2-wrap,
		#mvp-feat4-wrap,
		#mvp-post-feat-img-wide,
		#mvp-vid-wide-wrap {
			margin-top: -15px;
			}
		}
		";
	}

	$mvp_prime_skin = get_option('mvp_prime_skin');
	if($mvp_prime_skin == "Standard") {
	$mvp_prime_skin_css = "
	.mvp-vid-box-wrap,
	.mvp-feat1-left-wrap span.mvp-cd-cat,
	.mvp-widget-feat1-top-story span.mvp-cd-cat,
	.mvp-widget-feat2-left-cont span.mvp-cd-cat,
	.mvp-widget-dark-feat span.mvp-cd-cat,
	.mvp-widget-dark-sub span.mvp-cd-cat,
	.mvp-vid-wide-text span.mvp-cd-cat,
	.mvp-feat2-top-text span.mvp-cd-cat,
	.mvp-feat3-main-story span.mvp-cd-cat {
		color: #fff;
		}
		";
	}

	$mvp_para_lead = get_option('mvp_para_lead');
	if ($mvp_para_lead == "true") {
	if (isset($mvp_para_lead)) { } } else {
	$mvp_para_lead_css = "
	#mvp-leader-wrap {
		position: relative;
		}
	#mvp-site-main {
		margin-top: 0;
		}
	#mvp-leader-wrap {
		top: 0 !important;
		}
		";
	}

	$mvp_infinite_scroll = get_option('mvp_infinite_scroll');
	if ($mvp_infinite_scroll == "true") {
	if (isset($mvp_infinite_scroll)) {
	$mvp_infinite_scroll_css = "
	.mvp-nav-links {
		display: none;
		}
		";
	} }

	$mvp_respond = get_option('mvp_respond');
	if ($mvp_respond == "true") {
	if (isset($mvp_respond)) { } } else {
	$mvp_respond_css = "
	#mvp-site,
	#mvp-main-nav-top,
	#mvp-main-nav-bot {
		min-width: 1240px;
		}
		";
	}

	$mvp_cont_read = get_option('mvp_cont_read');
	if ($mvp_cont_read == "true") {
	if (isset($mvp_cont_read)) {
	$mvp_cont_read_css = "
	@media screen and (max-width: 479px) {
		.single #mvp-content-body-top {
			max-height: 400px;
			}
		.single .mvp-cont-read-but-wrap {
			display: inline;
			}
		}
		";
	} }

	$mvp_rtl = get_option('mvp_rtl'); if ($mvp_rtl == "true") {
	global $post; if (!empty( $post )) {
	$mvp_post_layout = get_option('mvp_post_layout');
	$mvp_post_temp = get_post_meta($post->ID, "mvp_post_template", true);
	if( ( empty($mvp_post_temp) && $mvp_post_layout == 'Template 2' ) || ( $mvp_post_temp == "def" && $mvp_post_layout == 'Template 2' ) || ( empty($mvp_post_temp) && $mvp_post_layout == 'Template 8' ) || ( $mvp_post_temp == "def" && $mvp_post_layout == 'Template 8' ) || ( $mvp_post_temp == "global" && $mvp_post_layout == 'Template 2' ) || ( $mvp_post_temp == "global" && $mvp_post_layout == 'Template 8' ) || $mvp_post_temp == "temp2" || $mvp_post_temp == "temp8" ) {
	$mvp_post_side_css = "
	.mvp-post-main-out,
	.mvp-post-main-in {
		margin-left: 0 !important;
		}
	#mvp-post-feat-img img {
		width: 100%;
		}
	#mvp-content-wrap,
	#mvp-post-add-box {
		float: none;
		margin: 0 auto;
		max-width: 750px;
		}
		";
	}
	}
	} else {
	global $post; if (!empty( $post )) {
	$mvp_post_layout = get_option('mvp_post_layout');
	$mvp_post_temp = get_post_meta($post->ID, "mvp_post_template", true);
	if( ( empty($mvp_post_temp) && $mvp_post_layout == 'Template 2' ) || ( $mvp_post_temp == "def" && $mvp_post_layout == 'Template 2' ) || ( empty($mvp_post_temp) && $mvp_post_layout == 'Template 8' ) || ( $mvp_post_temp == "def" && $mvp_post_layout == 'Template 8' ) || ( $mvp_post_temp == "global" && $mvp_post_layout == 'Template 2' ) || ( $mvp_post_temp == "global" && $mvp_post_layout == 'Template 8' ) || $mvp_post_temp == "temp2" || $mvp_post_temp == "temp8" ) {
	$mvp_post_side_css = "
	.mvp-post-main-out,
	.mvp-post-main-in {
		margin-right: 0 !important;
		}
	#mvp-post-feat-img img {
		width: 100%;
		}
	#mvp-content-wrap,
	#mvp-post-add-box {
		float: none;
		margin: 0 auto;
		max-width: 750px;
		}
		";
	}
	}
	}

	$mvp_rtl = get_option('mvp_rtl'); if ($mvp_rtl == "true") {
	global $post; if (!empty( $post )) {
	$mvp_post_layout = get_option('mvp_post_layout');
	$mvp_post_temp = get_post_meta($post->ID, "mvp_post_template", true);
	if( ( empty($mvp_post_temp) && $mvp_post_layout == 'Template 4' ) || ( $mvp_post_temp == "def" && $mvp_post_layout == 'Template 4' ) || ( empty($mvp_post_temp) && $mvp_post_layout == 'Template 6' ) || ( $mvp_post_temp == "def" && $mvp_post_layout == 'Template 6' ) || ( $mvp_post_temp == "global" && $mvp_post_layout == 'Template 4' ) || ( $mvp_post_temp == "global" && $mvp_post_layout == 'Template 6' ) || $mvp_post_temp == "temp4" || $mvp_post_temp == "temp6" ) {
	$mvp_post_side2_css = "
	.mvp-post-main-out,
	.mvp-post-main-in {
		margin-left: 0 !important;
		}
	#mvp-post-feat-img img {
		width: 100%;
		}
	#mvp-post-content,
	#mvp-post-add-box {
		float: none;
		margin: 0 auto;
		max-width: 750px;
		}
		";
	}
	}
	} else {
	global $post; if (!empty( $post )) {
	$mvp_post_layout = get_option('mvp_post_layout');
	$mvp_post_temp = get_post_meta($post->ID, "mvp_post_template", true);
	if( ( empty($mvp_post_temp) && $mvp_post_layout == 'Template 4' ) || ( $mvp_post_temp == "def" && $mvp_post_layout == 'Template 4' ) || ( empty($mvp_post_temp) && $mvp_post_layout == 'Template 6' ) || ( $mvp_post_temp == "def" && $mvp_post_layout == 'Template 6' ) || ( $mvp_post_temp == "global" && $mvp_post_layout == 'Template 4' ) || ( $mvp_post_temp == "global" && $mvp_post_layout == 'Template 6' ) || $mvp_post_temp == "temp4" || $mvp_post_temp == "temp6" ) {
	$mvp_post_side2_css = "
	.mvp-post-main-out,
	.mvp-post-main-in {
		margin-right: 0 !important;
		}
	#mvp-post-feat-img img {
		width: 100%;
		}
	#mvp-post-content,
	#mvp-post-add-box {
		float: none;
		margin: 0 auto;
		max-width: 750px;
		}
		";
	}
	}
	}

	if ( is_single() ) {
	$mvp_rtl = get_option('mvp_rtl'); if ($mvp_rtl == "true") {
	global $post; if (!empty( $post )) {
	$mvp_post_layout = get_option('mvp_post_layout');
	$mvp_post_temp = get_post_meta($post->ID, "mvp_post_template", true);
	if( ( empty($mvp_post_temp) && $mvp_post_layout == 'Template 5' ) || ( $mvp_post_temp == "def" && $mvp_post_layout == 'Template 5' ) || ( empty($mvp_post_temp) && $mvp_post_layout == 'Template 6' ) || ( $mvp_post_temp == "def" && $mvp_post_layout == 'Template 6' ) || ( $mvp_post_temp == "global" && $mvp_post_layout == 'Template 5' ) || ( $mvp_post_temp == "global" && $mvp_post_layout == 'Template 6' ) || $mvp_post_temp == "temp5" || $mvp_post_temp == "temp6" ) {
	$mvp_post_side3_css = "
	.mvp-nav-soc-wrap {
		margin-top: -15px;
		height: 30px;
		}
	span.mvp-nav-soc-but {
		font-size: 16px;
		padding-top: 7px;
		width: 30px;
		height: 23px;
		}
	#mvp-main-nav-top {
		padding: 10px 0 !important;
		height: 30px !important;
		z-index: 9999;
		}
	.mvp-nav-top-wrap,
	.mvp-nav-top-mid {
		height: 30px !important;
		}
	.mvp-nav-top-mid img {
		height: 100% !important;
		}
	#mvp-main-nav-bot {
		border-bottom: none;
		display: none;
		height: 0;
		}
	.mvp-nav-top-mid img {
		margin-right: 0;
		}
	.mvp-nav-top-left-out {
		margin-right: -200px;
		}
	.mvp-nav-top-left-in {
		margin-right: 200px;
		}
	.mvp-nav-top-left {
		display: block;
		}
		";
	}
	}
	} else {
	global $post; if (!empty( $post )) {
	$mvp_post_layout = get_option('mvp_post_layout');
	$mvp_post_temp = get_post_meta($post->ID, "mvp_post_template", true);
	if( ( empty($mvp_post_temp) && $mvp_post_layout == 'Template 5' ) || ( $mvp_post_temp == "def" && $mvp_post_layout == 'Template 5' ) || ( empty($mvp_post_temp) && $mvp_post_layout == 'Template 6' ) || ( $mvp_post_temp == "def" && $mvp_post_layout == 'Template 6' ) || ( $mvp_post_temp == "global" && $mvp_post_layout == 'Template 5' ) || ( $mvp_post_temp == "global" && $mvp_post_layout == 'Template 6' ) || $mvp_post_temp == "temp5" || $mvp_post_temp == "temp6" ) {
	$mvp_post_side3_css = "
	.mvp-nav-soc-wrap {
		margin-top: -15px;
		height: 30px;
		}
	span.mvp-nav-soc-but {
		font-size: 16px;
		padding-top: 7px;
		width: 30px;
		height: 23px;
		}
	#mvp-main-nav-top {
		padding: 10px 0 !important;
		height: 30px !important;
		z-index: 9999;
		}
	.mvp-nav-top-wrap,
	.mvp-nav-top-mid {
		height: 30px !important;
		}
	.mvp-nav-top-mid img {
		height: 100% !important;
		}
	#mvp-main-nav-bot {
		border-bottom: none;
		display: none;
		height: 0;
		}
	.mvp-nav-top-mid img {
		margin-left: 0;
		}
	.mvp-nav-top-left-out {
		margin-left: -200px;
		}
	.mvp-nav-top-left-in {
		margin-left: 200px;
		}
	.mvp-nav-top-left {
		display: block;
		}
		";
	}
	}
	}
	}

	if ($mvp_customcss) {
	$mvp_customcss_css = "
 	$mvp_customcss
		";
	}

	if (isset($mvp_theme_options)) { wp_kses_post(wp_add_inline_style( 'mvp-custom-style', $mvp_theme_options )); }
	if (isset($mvp_wall_ad_css)) { wp_kses_post(wp_add_inline_style( 'mvp-custom-style', $mvp_wall_ad_css )); }
	if (isset($mvp_prime_skin_css)) { wp_kses_post(wp_add_inline_style( 'mvp-custom-style', $mvp_prime_skin_css )); }
	if (isset($mvp_site_skin_css)) { wp_kses_post(wp_add_inline_style( 'mvp-custom-style', $mvp_site_skin_css )); }
	if (isset($mvp_nav_skin_css)) { wp_kses_post(wp_add_inline_style( 'mvp-custom-style', $mvp_nav_skin_css )); }
	if (isset($mvp_nav_layout_css)) { wp_kses_post(wp_add_inline_style( 'mvp-custom-style', $mvp_nav_layout_css )); }
	if (isset($mvp_para_lead_css)) { wp_kses_post(wp_add_inline_style( 'mvp-custom-style', $mvp_para_lead_css )); }
	if (isset($mvp_infinite_scroll_css)) { wp_kses_post(wp_add_inline_style( 'mvp-custom-style', $mvp_infinite_scroll_css )); }
	if (isset($mvp_respond_css)) { wp_kses_post(wp_add_inline_style( 'mvp-custom-style', $mvp_respond_css )); }
	if (isset($mvp_cont_read_css)) { wp_kses_post(wp_add_inline_style( 'mvp-custom-style', $mvp_cont_read_css )); }
	if (isset($mvp_post_side_css)) { wp_kses_post(wp_add_inline_style( 'mvp-custom-style', $mvp_post_side_css )); }
	if (isset($mvp_post_side2_css)) { wp_kses_post(wp_add_inline_style( 'mvp-custom-style', $mvp_post_side2_css )); }
	if (isset($mvp_post_side3_css)) { wp_kses_post(wp_add_inline_style( 'mvp-custom-style', $mvp_post_side3_css )); }
	if (isset($mvp_customcss_css)) { wp_kses_post(wp_add_inline_style( 'mvp-custom-style', $mvp_customcss_css )); }
}
}
add_action( 'wp_enqueue_scripts', 'mvp_styles_method' );

/////////////////////////////////////
// Enqueue Javascript/CSS Files
/////////////////////////////////////

if ( ! function_exists( 'mvp_scripts_method' ) ) {
function mvp_scripts_method() {
	global $wp_styles;
	wp_enqueue_style( 'mvp-reset', get_template_directory_uri() . '/css/reset.css' );
	wp_enqueue_style( 'fontawesome', get_stylesheet_directory_uri() . '/font-awesome/css/font-awesome.css' );
	wp_enqueue_style( 'mvp-iecss', get_stylesheet_directory_uri() . '/css/iecss.css', array( 'mvp-style' )  );
	wp_enqueue_style( 'mvp-fonts', mvp_fonts_url(), array(), null );
	$wp_styles->add_data( 'mvp-iecss', 'conditional', 'lt IE 10' );
	$mvp_rtl = get_option('mvp_rtl'); if ($mvp_rtl == "true") { if (isset($mvp_rtl)) {
	wp_enqueue_style( 'mvp-rtl', get_template_directory_uri() . '/css/rtl.css' );
	} }
	$mvp_respond = get_option('mvp_respond'); if ($mvp_respond == "true") { if (isset($mvp_respond)) {
	$mvp_rtl = get_option('mvp_rtl'); if ($mvp_rtl == "true") { if (isset($mvp_rtl)) {
	wp_enqueue_style( 'mvp-media-queries', get_template_directory_uri() . '/css/media-queries-rtl.css' );
	} } else {
	wp_enqueue_style( 'mvp-media-queries', get_template_directory_uri() . '/css/media-queries.css' );
	} } }
	wp_register_script('mvp-custom', get_template_directory_uri() . '/js/mvpcustom.js', array('jquery'), '', true);
	wp_register_script('zoxnews', get_template_directory_uri() . '/js/scripts.js', array('jquery'), '', true);
	wp_register_script('retina', get_template_directory_uri() . '/js/retina.js', array('jquery'), '', true);
	wp_register_script('flexslider', get_template_directory_uri() . '/js/flexslider.js', array('jquery'), '', true);
	wp_register_script('infinitescroll', get_template_directory_uri() . '/js/jquery.infinitescroll.min.js', array('jquery'), '', true);

	wp_enqueue_script('mvp-custom');
	wp_enqueue_script('zoxnews');
	wp_enqueue_script('retina');
	if ( is_single() ) wp_enqueue_script( 'flexslider' );
	$mvp_infinite_scroll = get_option('mvp_infinite_scroll'); if ($mvp_infinite_scroll == "true") { if (isset($mvp_infinite_scroll)) {
	wp_enqueue_script('infinitescroll');
	} }

	if ( is_singular() ) wp_enqueue_script( 'comment-reply' );

$mvp_nav_layout = get_option('mvp_nav_layout'); if( $mvp_nav_layout == "Small" ) {

	if ( is_single() ) {
	wp_add_inline_script( 'mvp-custom', '
	jQuery(document).ready(function($) {
	$(window).load(function(){
	var leaderHeight = $("#mvp-leader-wrap").outerHeight();
	var navHeight = $("#mvp-main-head-wrap").outerHeight();
	var headerHeight = navHeight + leaderHeight;
	var previousScroll = 0;
	$(window).scroll(function(event){
			var scroll = $(this).scrollTop();
			if ($(window).scrollTop() > headerHeight){
				$("#mvp-main-nav-small").addClass("mvp-nav-small-fixed");
				$("#mvp-main-body-wrap").css("margin-top", navHeight );
			} else {
				$("#mvp-main-nav-small").removeClass("mvp-nav-small-fixed");
				$("#mvp-main-body-wrap").css("margin-top","0");
			}
			if ($(window).scrollTop() > headerHeight + 50){
				$("#mvp-main-nav-small").addClass("mvp-fixed");
				$("#mvp-main-nav-small").addClass("mvp-fixed-shadow");
				$(".mvp-fly-top").addClass("mvp-to-top");
	    		if(scroll < previousScroll) {
					$("#mvp-main-nav-small").removeClass("mvp-soc-mob-up");
					$("#mvp-soc-mob-wrap").removeClass("mvp-soc-mob-up");
					$(".mvp-drop-nav-title").removeClass("mvp-nav-small-post");
					$(".mvp-nav-menu").show();
				} else {
					$("#mvp-main-nav-small").addClass("mvp-soc-mob-up");
					$("#mvp-soc-mob-wrap").addClass("mvp-soc-mob-up");
					$(".mvp-drop-nav-title").addClass("mvp-nav-small-post");
					$(".mvp-nav-menu").hide();
				}
			} else {
				$("#mvp-main-nav-small").removeClass("mvp-fixed");
				$("#mvp-main-nav-small").removeClass("mvp-fixed-shadow");
	    		$(".mvp-fly-top").removeClass("mvp-to-top");
			}
			previousScroll = scroll;
	});
	});
	});
	' );
	} else {
	wp_add_inline_script( 'mvp-custom', '
	jQuery(document).ready(function($) {
	$(window).load(function(){
	var leaderHeight = $("#mvp-leader-wrap").outerHeight();
	var navHeight = $("#mvp-main-head-wrap").outerHeight();
	var headerHeight = navHeight + leaderHeight;
	var previousScroll = 0;
	$(window).scroll(function(event){
			var scroll = $(this).scrollTop();
			if ($(window).scrollTop() > headerHeight){
				$("#mvp-main-nav-small").addClass("mvp-nav-small-fixed");
				$("#mvp-main-body-wrap").css("margin-top", navHeight );
			} else {
				$("#mvp-main-nav-small").removeClass("mvp-nav-small-fixed");
				$("#mvp-main-body-wrap").css("margin-top","0");
			}
			if ($(window).scrollTop() > headerHeight + 50){
				$("#mvp-main-nav-small").addClass("mvp-fixed");
				$("#mvp-main-nav-small").addClass("mvp-fixed-shadow");
				$(".mvp-fly-top").addClass("mvp-to-top");
			} else {
				$("#mvp-main-nav-small").removeClass("mvp-fixed");
				$("#mvp-main-nav-small").removeClass("mvp-fixed-shadow");
	    		$(".mvp-fly-top").removeClass("mvp-to-top");
			}
			previousScroll = scroll;
	});
	});
	});
	' );
	}

} else {
	if ( is_single() ) {
	wp_add_inline_script( 'mvp-custom', '
	jQuery(document).ready(function($) {
	$(window).load(function(){
	var leaderHeight = $("#mvp-leader-wrap").outerHeight();
	var logoHeight = $("#mvp-main-nav-top").outerHeight();
	var botHeight = $("#mvp-main-nav-bot").outerHeight();
	var navHeight = $("#mvp-main-head-wrap").outerHeight();
	var headerHeight = navHeight + leaderHeight;
	var aboveNav = leaderHeight + logoHeight;
	var totalHeight = logoHeight + botHeight;
	var previousScroll = 0;
	$(window).scroll(function(event){
			var scroll = $(this).scrollTop();
			if ($(window).scrollTop() > aboveNav){
				$("#mvp-main-nav-top").addClass("mvp-nav-small");
				$("#mvp-main-nav-bot").css("margin-top", logoHeight );
			} else {
				$("#mvp-main-nav-top").removeClass("mvp-nav-small");
				$("#mvp-main-nav-bot").css("margin-top","0");
			}
			if ($(window).scrollTop() > headerHeight){
				$("#mvp-main-nav-top").addClass("mvp-fixed");
				$("#mvp-main-nav-bot").addClass("mvp-fixed1");
				$("#mvp-main-body-wrap").css("margin-top", totalHeight );
				$("#mvp-main-nav-top").addClass("mvp-fixed-shadow");
				$(".mvp-nav-top-mid").addClass("mvp-fixed-post");
				$(".mvp-drop-nav-title").show();
				$(".mvp-fly-top").addClass("mvp-to-top");
	    		if(scroll < previousScroll) {
					$("#mvp-main-nav-bot").addClass("mvp-fixed2");
					$("#mvp-main-nav-top").removeClass("mvp-fixed-shadow");
					$("#mvp-main-nav-top").removeClass("mvp-soc-mob-up");
					$("#mvp-soc-mob-wrap").removeClass("mvp-soc-mob-up");
				} else {
					$("#mvp-main-nav-bot").removeClass("mvp-fixed2");
					$("#mvp-main-nav-top").addClass("mvp-fixed-shadow");
					$("#mvp-main-nav-top").addClass("mvp-soc-mob-up");
					$("#mvp-soc-mob-wrap").addClass("mvp-soc-mob-up");
				}
			} else {
				$("#mvp-main-nav-top").removeClass("mvp-fixed");
				$("#mvp-main-nav-bot").removeClass("mvp-fixed1");
				$("#mvp-main-nav-bot").removeClass("mvp-fixed2");
				$("#mvp-main-body-wrap").css("margin-top","0");
				$("#mvp-main-nav-top").removeClass("mvp-fixed-shadow");
				$(".mvp-nav-top-mid").removeClass("mvp-fixed-post");
				$(".mvp-drop-nav-title").hide();
	    		$(".mvp-fly-top").removeClass("mvp-to-top");
			}
			previousScroll = scroll;
	});
	});
	});
	' );
	} else {
	wp_add_inline_script( 'mvp-custom', '
	jQuery(document).ready(function($) {
	$(window).load(function(){
	var leaderHeight = $("#mvp-leader-wrap").outerHeight();
	var logoHeight = $("#mvp-main-nav-top").outerHeight();
	var botHeight = $("#mvp-main-nav-bot").outerHeight();
	var navHeight = $("#mvp-main-head-wrap").outerHeight();
	var headerHeight = navHeight + leaderHeight;
	var aboveNav = leaderHeight + logoHeight;
	var totalHeight = logoHeight + botHeight;
	var previousScroll = 0;
	$(window).scroll(function(event){
			var scroll = $(this).scrollTop();
			if ($(window).scrollTop() > aboveNav){
				$("#mvp-main-nav-top").addClass("mvp-nav-small");
				$("#mvp-main-nav-bot").css("margin-top", logoHeight );
			} else {
				$("#mvp-main-nav-top").removeClass("mvp-nav-small");
				$("#mvp-main-nav-bot").css("margin-top","0");
			}
			if ($(window).scrollTop() > headerHeight){
				$("#mvp-main-nav-top").addClass("mvp-fixed");
				$("#mvp-main-nav-bot").addClass("mvp-fixed1");
				$("#mvp-main-body-wrap").css("margin-top", totalHeight );
				$("#mvp-main-nav-top").addClass("mvp-fixed-shadow");
				$(".mvp-fly-top").addClass("mvp-to-top");
	    		if(scroll < previousScroll) {
					$("#mvp-main-nav-bot").addClass("mvp-fixed2");
					$("#mvp-main-nav-top").removeClass("mvp-fixed-shadow");
				} else {
					$("#mvp-main-nav-bot").removeClass("mvp-fixed2");
					$("#mvp-main-nav-top").addClass("mvp-fixed-shadow");
				}
			} else {
				$("#mvp-main-nav-top").removeClass("mvp-fixed");
				$("#mvp-main-nav-bot").removeClass("mvp-fixed1");
				$("#mvp-main-nav-bot").removeClass("mvp-fixed2");
				$("#mvp-main-body-wrap").css("margin-top","0");
				$("#mvp-main-nav-top").removeClass("mvp-fixed-shadow");
	    		$(".mvp-fly-top").removeClass("mvp-to-top");
			}
			previousScroll = scroll;
	});
	});
	});
	' );
	}
}

	$mvp_scroll_vid = get_option('mvp_scroll_vid'); if ($mvp_scroll_vid == "true") { if (isset($mvp_scroll_vid)) {
	if ( is_single() ) {
	wp_add_inline_script( 'mvp-custom', '
	jQuery(document).ready(function($) {
	// Video Post Scroll
	$(window).on("scroll.video", function(event){
		var scrollTop     = $(window).scrollTop();
    	var elementOffset = $("#mvp-content-wrap").offset().top;
    	var distance      = (elementOffset - scrollTop);
		var aboveHeight = $("#mvp-video-embed-wrap").outerHeight();
		if ($(window).scrollTop() > distance + aboveHeight + screen.height){
			$("#mvp-video-embed-cont").addClass("mvp-vid-fixed");
			$("#mvp-video-embed-wrap").addClass("mvp-vid-height");
			$(".mvp-video-close").show();
		} else {
			$("#mvp-video-embed-cont").removeClass("mvp-vid-fixed");
			$("#mvp-video-embed-wrap").removeClass("mvp-vid-height");
			$(".mvp-video-close").hide();
		}
	});

 	$(".mvp-video-close").on("click", function(){
		$("iframe").attr("src", $("iframe").attr("src"));
		$("#mvp-video-embed-cont").removeClass("mvp-vid-fixed");
		$("#mvp-video-embed-wrap").removeClass("mvp-vid-height");
		$(".mvp-video-close").hide();
		$(window).off("scroll.video");
  	});

	});
  	' );
	}
	} }

	global $post;
	$socialbox = get_option('mvp_social_box');
	if ($socialbox == "true") {
	if (isset($socialbox)) {
	wp_add_inline_script( 'mvp-custom', '
	jQuery(document).ready(function($) {
	// Mobile Social Buttons More
	$(window).load(function(){
 		$(".mvp-soc-mob-right").on("click", function(){
			$("#mvp-soc-mob-wrap").toggleClass("mvp-soc-mob-more");
  		});
  	});
	});
  	' );
	} }

	$mvp_cont_read = get_option('mvp_cont_read');
	if ($mvp_cont_read == "true") {
	if (isset($mvp_cont_read)) {
	wp_add_inline_script( 'mvp-custom', '
	jQuery(document).ready(function($) {
	// Continue Reading Button
	$(window).load(function(){
 		$(".mvp-cont-read-but").on("click", function(){
			$("#mvp-content-body-top").css("max-height","none");
			$("#mvp-content-body-top").css("overflow","visible");
			$(".mvp-cont-read-but-wrap").hide();
  		});
  	});
	});
  	' );
	} }

	// Parallax Leaderboard
	$mvp_para_lead = get_option('mvp_para_lead'); if ($mvp_para_lead == "true") { if (isset($mvp_para_lead)) {
	if(get_option('mvp_header_leader')) {
	wp_add_inline_script( 'mvp-custom', '
	jQuery(document).ready(function($) {
	$(window).load(function(){
		var leaderHeight = $("#mvp-leader-wrap").outerHeight();
		$("#mvp-site-main").css("margin-top", leaderHeight );
  	});

	$(window).resize(function(){
		var leaderHeight = $("#mvp-leader-wrap").outerHeight();
		$("#mvp-site-main").css("margin-top", leaderHeight );
	});

	});
  	' );
	}
	} }

	// Main Menu Dropdown Toggle
	wp_add_inline_script( 'mvp-custom', '
	jQuery(document).ready(function($) {
	$(".menu-item-has-children a").click(function(event){
	  event.stopPropagation();
	  location.href = this.href;
  	});

	$(".menu-item-has-children").click(function(){
    	  $(this).addClass("toggled");
    	  if($(".menu-item-has-children").hasClass("toggled"))
    	  {
    	  $(this).children("ul").toggle();
	  $(".mvp-fly-nav-menu").getNiceScroll().resize();
	  }
	  $(this).toggleClass("tog-minus");
    	  return false;
  	});

	// Main Menu Scroll
	$(window).load(function(){
	  $(".mvp-fly-nav-menu").niceScroll({cursorcolor:"#888",cursorwidth: 7,cursorborder: 0,zindex:999999});
	});
	});
	' );

	$mvp_infinite_scroll = get_option('mvp_infinite_scroll');
	if ($mvp_infinite_scroll == "true") { if (isset($mvp_infinite_scroll)) {
	wp_add_inline_script( 'mvp-custom', '
	jQuery(document).ready(function($) {
	$(".infinite-content").infinitescroll({
	  navSelector: ".mvp-nav-links",
	  nextSelector: ".mvp-nav-links a:first",
	  itemSelector: ".infinite-post",
	  errorCallback: function(){ $(".mvp-inf-more-but").css("display", "none") }
	});
	$(window).unbind(".infscr");
	$(".mvp-inf-more-but").click(function(){
   		$(".infinite-content").infinitescroll("retrieve");
        	return false;
	});
	$(window).load(function(){
		if ($(".mvp-nav-links a").length) {
			$(".mvp-inf-more-but").css("display","inline-block");
		} else {
			$(".mvp-inf-more-but").css("display","none");
		}
	});
	});
	' );
	}
	}

	if ( is_single() ) {
	global $post; $mvp_show_gallery = get_post_meta($post->ID, "mvp_post_gallery", true);
	if ($mvp_show_gallery == "show") {
	wp_add_inline_script( 'mvp-custom', '
	jQuery(document).ready(function($) {
	$(window).load(function() {
	  $(".mvp-post-gallery-bot").flexslider({
	    animation: "slide",
	    controlNav: false,
	    animationLoop: true,
	    slideshow: false,
	    itemWidth: 80,
	    itemMargin: 0,
	    asNavFor: ".mvp-post-gallery-top"
	  });

	  $(".mvp-post-gallery-top").flexslider({
	    animation: "fade",
	    controlNav: false,
	    animationLoop: true,
	    slideshow: false,
	    	  prevText: "&lt;",
	          nextText: "&gt;",
	    sync: ".mvp-post-gallery-bot"
	  });
	});
	});
	' );
	}
	}
	
}
}
add_action('wp_enqueue_scripts', 'mvp_scripts_method');

/////////////////////////////////////
// Register Widgets
/////////////////////////////////////

if ( !function_exists( 'mvp_sidebars_init' ) ) {
	function mvp_sidebars_init() {

		register_sidebar(array(
			'id' => 'homepage-widget',
			'name' => esc_html__( 'Homepage Widget Area', 'zox-news' ),
			'description'   => esc_html__( 'The widgetized area in the main content area of the homepage.', 'zox-news' ),
			'before_widget' => '<section id="%1$s" class="mvp-widget-home left relative %2$s"><div class="mvp-main-box">',
			'after_widget' => '</div></section>',
			'before_title' => '<div class="mvp-widget-home-head"><h4 class="mvp-widget-home-title"><span class="mvp-widget-home-title">',
			'after_title' => '</span></h4></div>',
		));

		register_sidebar(array(
			'id' => 'mvp-home-sidebar-widget',
			'name' => esc_html__( 'Homepage Sidebar Widget Area', 'zox-news' ),
			'description'   => esc_html__( 'The widgetized sidebar on the homepage.', 'zox-news' ),
			'before_widget' => '<section id="%1$s" class="mvp-side-widget %2$s">',
			'after_widget' => '</section>',
			'before_title' => '<div class="mvp-widget-home-head"><h4 class="mvp-widget-home-title"><span class="mvp-widget-home-title">',
			'after_title' => '</span></h4></div>',
		));

		register_sidebar(array(
			'id' => 'mvp-sidebar-widget',
			'name' => esc_html__( 'Default Sidebar Widget Area', 'zox-news' ),
			'description'   => esc_html__( 'The default widgetized sidebar.', 'zox-news' ),
			'before_widget' => '<section id="%1$s" class="mvp-side-widget %2$s">',
			'after_widget' => '</section>',
			'before_title' => '<div class="mvp-widget-home-head"><h4 class="mvp-widget-home-title"><span class="mvp-widget-home-title">',
			'after_title' => '</span></h4></div>',
		));

		register_sidebar(array(
			'id' => 'mvp-sidebar-widget-post',
			'name' => esc_html__( 'Post/Page Sidebar Widget Area', 'zox-news' ),
			'description'   => esc_html__( 'The widgetized sidebar on posts and pages.', 'zox-news' ),
			'before_widget' => '<section id="%1$s" class="mvp-side-widget %2$s">',
			'after_widget' => '</section>',
			'before_title' => '<div class="mvp-widget-home-head"><h4 class="mvp-widget-home-title"><span class="mvp-widget-home-title">',
			'after_title' => '</span></h4></div>',
		));

		register_sidebar(array(
			'id' => 'mvp-sidebar-woo-widget',
			'name' => esc_html__( 'WooCommerce Sidebar Widget Area', 'zox-news' ),
			'description'   => esc_html__( 'The widgetized sidebar on your WooCommerce pages.', 'zox-news' ),
			'before_widget' => '<section id="%1$s" class="mvp-side-widget %2$s">',
			'after_widget' => '</section>',
			'before_title' => '<div class="mvp-widget-home-head"><h4 class="mvp-widget-home-title2"><span class="mvp-widget-home-title2">',
			'after_title' => '</span></h4></div>',
		));

	}
}
add_action( 'widgets_init', 'mvp_sidebars_init' );

include( get_template_directory() . '/widgets/widget-ad.php');
include( get_template_directory() . '/widgets/widget-facebook.php');
include( get_template_directory() . '/widgets/widget-flex.php');
include( get_template_directory() . '/widgets/widget-home-dark.php');
include( get_template_directory() . '/widgets/widget-home-feat1.php');
include( get_template_directory() . '/widgets/widget-home-feat2.php');
include( get_template_directory() . '/widgets/widget-tabber.php');

/////////////////////////////////////
// Register Custom Menus
/////////////////////////////////////

if ( !function_exists( 'register_menus' ) ) {
function register_menus() {
	register_nav_menus(
		array(
			'main-menu' => esc_html__( 'Main Menu', 'zox-news' ),
			'mobile-menu' => esc_html__( 'Fly-Out Menu', 'zox-news' ),
			'footer-menu' => esc_html__( 'Footer Menu', 'zox-news' ))
	  	);
	  }
}
add_action( 'init', 'register_menus' );

/////////////////////////////////////
// Register Mega Menu
/////////////////////////////////////

add_filter( 'walker_nav_menu_start_el', 'mvp_walker_nav_menu_start_el', 10, 4 );

function mvp_walker_nav_menu_start_el( $item_output, $item, $depth, $args ) {
	global $wp_query;
    // The mega dropdown only applies to the main navigation.
    // Your theme location name may be different, "main" is just something I tend to use.
    if ( 'main-menu' !== $args->theme_location )
        return $item_output;

    // The mega dropdown needs to be added to one specific menu item.
    // I like to add a custom CSS class for that menu via the admin area.
    // You could also do an item ID check.
    if ( in_array( 'mvp-mega-dropdown', $item->classes ) ) {
        global $wp_query;
        global $post;
        $subposts = get_posts( 'numberposts=5&cat=' . $item->object_id );
	$item_output .= '<div class="mvp-mega-dropdown"><div class="mvp-main-box"><ul class="mvp-mega-list">';
            foreach( $subposts as $post ) :
                setup_postdata( $post );
		if ( has_post_format( 'video' )) {
                $item_output .= '<li><a href="'. get_permalink( $post->ID ) .'"><div class="mvp-mega-img">';
		$item_output .= get_the_post_thumbnail( $post->ID, 'mvp-mid-thumb' );
		$item_output .= '<div class="mvp-vid-box-wrap mvp-vid-box-small mvp-vid-marg-small"><i class="fa fa-play fa-3"></i></div></div><p>';
		$item_output .= get_the_title( $post->ID );
                $item_output .= '</p></a></li>';
		} else if ( has_post_format( 'gallery' )) {
                $item_output .= '<li><a href="'. get_permalink( $post->ID ) .'"><div class="mvp-mega-img">';
		$item_output .= get_the_post_thumbnail( $post->ID, 'mvp-mid-thumb' );
		$item_output .= '<div class="mvp-vid-box-wrap mvp-vid-box-small mvp-vid-marg-small"><i class="fa fa-camera fa-3"></i></div></div><p>';
		$item_output .= get_the_title( $post->ID );
                $item_output .= '</p></a></li>';
		} else {
                $item_output .= '<li><a href="'. get_permalink( $post->ID ) .'"><div class="mvp-mega-img">';
		$item_output .= get_the_post_thumbnail( $post->ID, 'mvp-mid-thumb' );
		$item_output .= '</div><p>';
		$item_output .= get_the_title( $post->ID );
                $item_output .= '</p></a></li>';
		}
            endforeach; wp_reset_postdata();
	$item_output .= '</ul></div></div>';

    }

    return $item_output;
}

/////////////////////////////////////
// Register Custom Background
/////////////////////////////////////

$custombg = array(
	'default-color' => 'ffffff',
);
add_theme_support( 'custom-background', $custombg );

/////////////////////////////////////
// Register Thumbnails
/////////////////////////////////////

if ( function_exists( 'add_theme_support' ) ) {
add_theme_support( 'post-thumbnails' );
set_post_thumbnail_size( 1000, 600, true );
add_image_size( 'mvp-post-thumb', 1000, 600, true );
add_image_size( 'mvp-port-thumb', 560, 600, true );
add_image_size( 'mvp-large-thumb', 590, 354, true );
add_image_size( 'mvp-mid-thumb', 400, 240, true );
add_image_size( 'mvp-small-thumb', 80, 80, true );
}

/////////////////////////////////////
// Title Meta Data
/////////////////////////////////////

add_theme_support( 'title-tag' );

function mvp_filter_home_title(){
if ( ( is_home() && ! is_front_page() ) || ( ! is_home() && is_front_page() ) ) {
    $mvpHomeTitle = get_bloginfo( 'name', 'display' );
    $mvpHomeDesc = get_bloginfo( 'description', 'display' );
    return $mvpHomeTitle . " - " . $mvpHomeDesc;
}
}
add_filter( 'pre_get_document_title', 'mvp_filter_home_title');

/////////////////////////////////////
// Add Custom Meta Box
/////////////////////////////////////

/* Fire our meta box setup function on the post editor screen. */
add_action( 'load-post.php', 'mvp_post_meta_boxes_setup' );
add_action( 'load-post-new.php', 'mvp_post_meta_boxes_setup' );

/* Meta box setup function. */
if ( !function_exists( 'mvp_post_meta_boxes_setup' ) ) {
function mvp_post_meta_boxes_setup() {

	/* Add meta boxes on the 'add_meta_boxes' hook. */
	add_action( 'add_meta_boxes', 'mvp_add_post_meta_boxes' );

	/* Save post meta on the 'save_post' hook. */
	add_action( 'save_post', 'mvp_save_video_embed_meta', 10, 2 );
	add_action( 'save_post', 'mvp_save_featured_headline_meta', 10, 2 );
	add_action( 'save_post', 'mvp_save_photo_credit_meta', 10, 2 );
	add_action( 'save_post', 'mvp_save_post_template_meta', 10, 2 );
	add_action( 'save_post', 'mvp_save_featured_image_meta', 10, 2 );
	add_action( 'save_post', 'mvp_save_post_gallery_meta', 10, 2 );
}
}

/* Create one or more meta boxes to be displayed on the post editor screen. */
if ( !function_exists( 'mvp_add_post_meta_boxes' ) ) {
function mvp_add_post_meta_boxes() {

	add_meta_box(
		'mvp-video-embed',			// Unique ID
		esc_html__( 'Video/Audio Embed', 'zox-news' ),		// Title
		'mvp_video_embed_meta_box',		// Callback function
		'post',					// Admin page (or post type)
		'normal',				// Context
		'high'					// Priority
	);

	add_meta_box(
		'mvp-featured-headline',			// Unique ID
		esc_html__( 'Featured Headline', 'zox-news' ),		// Title
		'mvp_featured_headline_meta_box',		// Callback function
		'post',					// Admin page (or post type)
		'normal',				// Context
		'high'					// Priority
	);

	add_meta_box(
		'mvp-photo-credit',			// Unique ID
		esc_html__( 'Featured Image Caption', 'zox-news' ),		// Title
		'mvp_photo_credit_meta_box',		// Callback function
		'post',					// Admin page (or post type)
		'normal',				// Context
		'high'					// Priority
	);

	add_meta_box(
		'mvp-post-template',			// Unique ID
		esc_html__( 'Post Template', 'zox-news' ),		// Title
		'mvp_post_template_meta_box',		// Callback function
		'post',					// Admin page (or post type)
		'side',					// Context
		'core'					// Priority
	);

	add_meta_box(
		'mvp-featured-image',			// Unique ID
		esc_html__( 'Featured Image Show/Hide', 'zox-news' ),		// Title
		'mvp_featured_image_meta_box',		// Callback function
		'post',					// Admin page (or post type)
		'side',					// Context
		'core'					// Priority
	);

	add_meta_box(
		'mvp-post-gallery',			// Unique ID
		esc_html__( 'Post Gallery Show/Hide', 'zox-news' ),		// Title
		'mvp_post_gallery_meta_box',		// Callback function
		'post',					// Admin page (or post type)
		'side',					// Context
		'core'					// Priority
	);
}
}

/* Display the post meta box. */
if ( !function_exists( 'mvp_featured_headline_meta_box' ) ) {
function mvp_featured_headline_meta_box( $object, $box ) { ?>

	<?php wp_nonce_field( 'mvp_save_featured_headline_meta', 'mvp_featured_headline_nonce' ); ?>

	<p>
		<label for="mvp-featured-headline"><?php esc_html_e( "Add a custom featured headline that will be displayed in the featured slider.", 'zox-news' ); ?></label>
		<br />
		<input class="widefat" type="text" name="mvp-featured-headline" id="mvp-featured-headline" value="<?php echo esc_html( get_post_meta( $object->ID, 'mvp_featured_headline', true ) ); ?>" size="30" />
	</p>

<?php }
}

/* Display the post meta box. */
if ( !function_exists( 'mvp_video_embed_meta_box' ) ) {
function mvp_video_embed_meta_box( $object, $box ) { ?>

	<?php wp_nonce_field( 'mvp_save_video_embed_meta', 'mvp_video_embed_nonce' ); ?>

	<p>
		<label for="mvp-video-embed"><?php esc_html_e( "Enter your video or audio embed code.", 'zox-news' ); ?></label>
		<br />
		<input class="widefat" type="text" name="mvp-video-embed" id="mvp-video-embed" value="<?php echo esc_html( get_post_meta( $object->ID, 'mvp_video_embed', true ) ); ?>" />
	</p>

<?php }
}

/* Display the post meta box. */
if ( !function_exists( 'mvp_photo_credit_meta_box' ) ) {
function mvp_photo_credit_meta_box( $object, $box ) { ?>

	<?php wp_nonce_field( 'mvp_save_photo_credit_meta', 'mvp_photo_credit_nonce' ); ?>

	<p>
		<label for="mvp-photo-credit"><?php esc_html_e( "Add a caption and/or photo credit information for the featured image.", 'zox-news' ); ?></label>
		<br />
		<input class="widefat" type="text" name="mvp-photo-credit" id="mvp-photo-credit" value="<?php echo esc_html( get_post_meta( $object->ID, 'mvp_photo_credit', true ) ); ?>" size="30" />
	</p>

<?php }
}

/* Display the post meta box. */
if ( !function_exists( 'mvp_post_template_meta_box' ) ) {
function mvp_post_template_meta_box( $object, $box ) { ?>

	<?php wp_nonce_field( 'mvp_save_post_template_meta', 'mvp_post_template_nonce' ); $selected = esc_html( get_post_meta( $object->ID, 'mvp_post_template', true ) ); ?>

	<p>
		<label for="mvp-post-template"><?php esc_html_e( "Select a template for your post.", 'zox-news' ); ?></label>
		<br /><br />
		<select class="widefat" name="mvp-post-template" id="mvp-post-template">
			<option value="global" <?php selected( $selected, 'global' ); ?>>Use Global Setting</option>
			<option value="temp1" <?php selected( $selected, 'temp1' ); ?>>Template 1</option>
			<option value="temp2" <?php selected( $selected, 'temp2' ); ?>>Template 2</option>
			<option value="temp3" <?php selected( $selected, 'temp3' ); ?>>Template 3</option>
			<option value="temp4" <?php selected( $selected, 'temp4' ); ?>>Template 4</option>
			<option value="temp5" <?php selected( $selected, 'temp5' ); ?>>Template 5</option>
			<option value="temp6" <?php selected( $selected, 'temp6' ); ?>>Template 6</option>
			<option value="temp7" <?php selected( $selected, 'temp7' ); ?>>Template 7</option>
			<option value="temp8" <?php selected( $selected, 'temp8' ); ?>>Template 8</option>
        	</select>
	</p>
<?php }
}

/* Display the post meta box. */
if ( !function_exists( 'mvp_featured_image_meta_box' ) ) {
function mvp_featured_image_meta_box( $object, $box ) { ?>

	<?php wp_nonce_field( 'mvp_save_featured_image_meta', 'mvp_featured_image_nonce' ); $selected = esc_html( get_post_meta( $object->ID, 'mvp_featured_image', true ) ); ?>

	<p>
		<label for="mvp-featured-image"><?php esc_html_e( "Select to show or hide the featured image from automatically displaying in this post.", 'zox-news' ); ?></label>
		<br /><br />
		<select class="widefat" name="mvp-featured-image" id="mvp-featured-image">
            		<option value="show" <?php selected( $selected, 'show' ); ?>>Show</option>
            		<option value="hide" <?php selected( $selected, 'hide' ); ?>>Hide</option>
        	</select>
	</p>
<?php }
}

/* Display the post meta box. */
if ( !function_exists( 'mvp_post_gallery_meta_box' ) ) {
function mvp_post_gallery_meta_box( $object, $box ) { ?>

	<?php wp_nonce_field( 'mvp_save_post_gallery_meta', 'mvp_post_gallery_nonce' ); $selected = esc_html( get_post_meta( $object->ID, 'mvp_post_gallery', true ) ); ?>

	<p>
		<label for="mvp-post-gallery"><?php esc_html_e( "Select to show or hide the built-in gallery feature for this post.", 'zox-news' ); ?></label>
		<br /><br />
		<select class="widefat" name="mvp-post-gallery" id="mvp-post-gallery">
            		<option value="hide" <?php selected( $selected, 'hide' ); ?>>Hide</option>
            		<option value="show" <?php selected( $selected, 'show' ); ?>>Show</option>
        	</select>
	</p>
<?php }
}

/* Save the meta box's post metadata. */
if ( !function_exists( 'mvp_save_video_embed_meta' ) ) {
function mvp_save_video_embed_meta( $post_id, $post ) {

	/* Verify the nonce before proceeding. */
	if ( !isset( $_POST['mvp_video_embed_nonce'] ) || !wp_verify_nonce( $_POST['mvp_video_embed_nonce'], 'mvp_save_video_embed_meta' ) )
		return $post_id;

	/* Get the post type object. */
	$post_type = get_post_type_object( $post->post_type );

	/* Check if the current user has permission to edit the post. */
	if ( !current_user_can( $post_type->cap->edit_post, $post_id ) )
		return $post_id;

	/* Get the posted data and sanitize it for use as an HTML class. */
	$new_meta_value = ( isset( $_POST['mvp-video-embed'] ) ? balanceTags( $_POST['mvp-video-embed'] ) : '' );

	/* Get the meta key. */
	$meta_key = 'mvp_video_embed';

	/* Get the meta value of the custom field key. */
	$meta_value = get_post_meta( $post_id, $meta_key, true );

	/* If a new meta value was added and there was no previous value, add it. */
	if ( $new_meta_value && '' == $meta_value )
		add_post_meta( $post_id, $meta_key, $new_meta_value, true );

	/* If the new meta value does not match the old value, update it. */
	elseif ( $new_meta_value && $new_meta_value != $meta_value )
		update_post_meta( $post_id, $meta_key, $new_meta_value );

	/* If there is no new meta value but an old value exists, delete it. */
	elseif ( '' == $new_meta_value && $meta_value )
		delete_post_meta( $post_id, $meta_key, $meta_value );
} }

/* Save the meta box's post metadata. */
if ( !function_exists( 'mvp_save_featured_headline_meta' ) ) {
function mvp_save_featured_headline_meta( $post_id, $post ) {

	/* Verify the nonce before proceeding. */
	if ( !isset( $_POST['mvp_featured_headline_nonce'] ) || !wp_verify_nonce( $_POST['mvp_featured_headline_nonce'], 'mvp_save_featured_headline_meta' ) )
		return $post_id;

	/* Get the post type object. */
	$post_type = get_post_type_object( $post->post_type );

	/* Check if the current user has permission to edit the post. */
	if ( !current_user_can( $post_type->cap->edit_post, $post_id ) )
		return $post_id;

	/* Get the posted data and sanitize it for use as an HTML class. */
	$new_meta_value = ( isset( $_POST['mvp-featured-headline'] ) ? balanceTags( $_POST['mvp-featured-headline'] ) : '' );

	/* Get the meta key. */
	$meta_key = 'mvp_featured_headline';

	/* Get the meta value of the custom field key. */
	$meta_value = get_post_meta( $post_id, $meta_key, true );

	/* If a new meta value was added and there was no previous value, add it. */
	if ( $new_meta_value && '' == $meta_value )
		add_post_meta( $post_id, $meta_key, $new_meta_value, true );

	/* If the new meta value does not match the old value, update it. */
	elseif ( $new_meta_value && $new_meta_value != $meta_value )
		update_post_meta( $post_id, $meta_key, $new_meta_value );

	/* If there is no new meta value but an old value exists, delete it. */
	elseif ( '' == $new_meta_value && $meta_value )
		delete_post_meta( $post_id, $meta_key, $meta_value );
} }

/* Save the meta box's post metadata. */
if ( !function_exists( 'mvp_save_photo_credit_meta' ) ) {
function mvp_save_photo_credit_meta( $post_id, $post ) {

	/* Verify the nonce before proceeding. */
	if ( !isset( $_POST['mvp_photo_credit_nonce'] ) || !wp_verify_nonce( $_POST['mvp_photo_credit_nonce'], 'mvp_save_photo_credit_meta' ) )
		return $post_id;

	/* Get the post type object. */
	$post_type = get_post_type_object( $post->post_type );

	/* Check if the current user has permission to edit the post. */
	if ( !current_user_can( $post_type->cap->edit_post, $post_id ) )
		return $post_id;

	/* Get the posted data and sanitize it for use as an HTML class. */
	$new_meta_value = ( isset( $_POST['mvp-photo-credit'] ) ? balanceTags( $_POST['mvp-photo-credit'] ) : '' );

	/* Get the meta key. */
	$meta_key = 'mvp_photo_credit';

	/* Get the meta value of the custom field key. */
	$meta_value = get_post_meta( $post_id, $meta_key, true );

	/* If a new meta value was added and there was no previous value, add it. */
	if ( $new_meta_value && '' == $meta_value )
		add_post_meta( $post_id, $meta_key, $new_meta_value, true );

	/* If the new meta value does not match the old value, update it. */
	elseif ( $new_meta_value && $new_meta_value != $meta_value )
		update_post_meta( $post_id, $meta_key, $new_meta_value );

	/* If there is no new meta value but an old value exists, delete it. */
	elseif ( '' == $new_meta_value && $meta_value )
		delete_post_meta( $post_id, $meta_key, $meta_value );
} }

/* Save the meta box's post metadata. */
if ( !function_exists( 'mvp_save_post_template_meta' ) ) {
function mvp_save_post_template_meta( $post_id, $post ) {

	/* Verify the nonce before proceeding. */
	if ( !isset( $_POST['mvp_post_template_nonce'] ) || !wp_verify_nonce( $_POST['mvp_post_template_nonce'], 'mvp_save_post_template_meta' ) )
		return $post_id;

	/* Get the post type object. */
	$post_type = get_post_type_object( $post->post_type );

	/* Check if the current user has permission to edit the post. */
	if ( !current_user_can( $post_type->cap->edit_post, $post_id ) )
		return $post_id;

	/* Get the posted data and sanitize it for use as an HTML class. */
	$new_meta_value = ( isset( $_POST['mvp-post-template'] ) ? balanceTags( $_POST['mvp-post-template'] ) : '' );

	/* Get the meta key. */
	$meta_key = 'mvp_post_template';

	/* Get the meta value of the custom field key. */
	$meta_value = get_post_meta( $post_id, $meta_key, true );

	/* If a new meta value was added and there was no previous value, add it. */
	if ( $new_meta_value && '' == $meta_value )
		add_post_meta( $post_id, $meta_key, $new_meta_value, true );

	/* If the new meta value does not match the old value, update it. */
	elseif ( $new_meta_value && $new_meta_value != $meta_value )
		update_post_meta( $post_id, $meta_key, $new_meta_value );

	/* If there is no new meta value but an old value exists, delete it. */
	elseif ( '' == $new_meta_value && $meta_value )
		delete_post_meta( $post_id, $meta_key, $meta_value );
} }

/* Save the meta box's post metadata. */
if ( !function_exists( 'mvp_save_featured_image_meta' ) ) {
function mvp_save_featured_image_meta( $post_id, $post ) {

	/* Verify the nonce before proceeding. */
	if ( !isset( $_POST['mvp_featured_image_nonce'] ) || !wp_verify_nonce( $_POST['mvp_featured_image_nonce'], 'mvp_save_featured_image_meta' ) )
		return $post_id;

	/* Get the post type object. */
	$post_type = get_post_type_object( $post->post_type );

	/* Check if the current user has permission to edit the post. */
	if ( !current_user_can( $post_type->cap->edit_post, $post_id ) )
		return $post_id;

	/* Get the posted data and sanitize it for use as an HTML class. */
	$new_meta_value = ( isset( $_POST['mvp-featured-image'] ) ? balanceTags( $_POST['mvp-featured-image'] ) : '' );

	/* Get the meta key. */
	$meta_key = 'mvp_featured_image';

	/* Get the meta value of the custom field key. */
	$meta_value = get_post_meta( $post_id, $meta_key, true );

	/* If a new meta value was added and there was no previous value, add it. */
	if ( $new_meta_value && '' == $meta_value )
		add_post_meta( $post_id, $meta_key, $new_meta_value, true );

	/* If the new meta value does not match the old value, update it. */
	elseif ( $new_meta_value && $new_meta_value != $meta_value )
		update_post_meta( $post_id, $meta_key, $new_meta_value );

	/* If there is no new meta value but an old value exists, delete it. */
	elseif ( '' == $new_meta_value && $meta_value )
		delete_post_meta( $post_id, $meta_key, $meta_value );
} }

/* Save the meta box's post metadata. */
if ( !function_exists( 'mvp_save_post_gallery_meta' ) ) {
function mvp_save_post_gallery_meta( $post_id, $post ) {

	/* Verify the nonce before proceeding. */
	if ( !isset( $_POST['mvp_post_gallery_nonce'] ) || !wp_verify_nonce( $_POST['mvp_post_gallery_nonce'], 'mvp_save_post_gallery_meta' ) )
		return $post_id;

	/* Get the post type object. */
	$post_type = get_post_type_object( $post->post_type );

	/* Check if the current user has permission to edit the post. */
	if ( !current_user_can( $post_type->cap->edit_post, $post_id ) )
		return $post_id;

	/* Get the posted data and sanitize it for use as an HTML class. */
	$new_meta_value = ( isset( $_POST['mvp-post-gallery'] ) ? balanceTags( $_POST['mvp-post-gallery'] ) : '' );

	/* Get the meta key. */
	$meta_key = 'mvp_post_gallery';

	/* Get the meta value of the custom field key. */
	$meta_value = get_post_meta( $post_id, $meta_key, true );

	/* If a new meta value was added and there was no previous value, add it. */
	if ( $new_meta_value && '' == $meta_value )
		add_post_meta( $post_id, $meta_key, $new_meta_value, true );

	/* If the new meta value does not match the old value, update it. */
	elseif ( $new_meta_value && $new_meta_value != $meta_value )
		update_post_meta( $post_id, $meta_key, $new_meta_value );

	/* If there is no new meta value but an old value exists, delete it. */
	elseif ( '' == $new_meta_value && $meta_value )
		delete_post_meta( $post_id, $meta_key, $meta_value );
} }

/////////////////////////////////////
// Comments
/////////////////////////////////////

if ( !function_exists( 'mvp_comment' ) ) {
function mvp_comment( $comment, $args, $depth ) {
	$GLOBALS['comment'] = $comment;
	switch ( $comment->comment_type ) :
		case '' :
	?>
	<li <?php comment_class(); ?> id="li-comment-<?php comment_ID(); ?>">
		<div class="comment-wrapper" id="comment-<?php comment_ID(); ?>">
			<div class="comment-inner">
				<div class="comment-avatar">
					<?php echo get_avatar( $comment, 46 ); ?>
				</div>
				<div class="commentmeta">
					<p class="comment-meta-1">
						<?php printf( esc_html__( '%s ', 'zox-news'), sprintf( '<cite class="fn">%s</cite>', get_comment_author_link() ) ); ?>
					</p>
					<p class="comment-meta-2">
						<?php echo get_comment_date(); ?> <?php esc_html_e( 'at', 'zox-news'); ?> <?php echo get_comment_time(); ?>
						<?php edit_comment_link( esc_html__( 'Edit', 'zox-news'), '(' , ')'); ?>
					</p>
				</div>
				<div class="text">
					<?php if ( $comment->comment_approved == '0' ) : ?>
						<p class="waiting_approval"><?php esc_html_e( 'Your comment is awaiting moderation.', 'zox-news' ); ?></p>
					<?php endif; ?>
					<div class="c">
						<?php comment_text(); ?>
					</div>
				</div><!-- .text  -->
				<div class="clear"></div>
				<div class="comment-reply"><span class="reply"><?php comment_reply_link( array_merge( $args, array( 'depth' => $depth, 'max_depth' => $args['max_depth'] ) ) ); ?></span></div>
			</div><!-- comment-inner  -->
		</div><!-- comment-wrapper  -->
	<?php
			break;
		case 'pingback'  :
		case 'trackback' :
	?>
	<li class="post pingback">
		<p><?php esc_html_e( 'Pingback:', 'zox-news' ); ?> <?php comment_author_link(); ?><?php edit_comment_link( esc_html__( 'Edit', 'zox-news' ), ' ' ); ?></p>
	<?php
			break;
	endswitch;
}
}

if ( !function_exists( 'mvpClickCommmentButton' ) ) {
function mvpClickCommmentButton($disqus_shortname){
    global $post;
    echo '
    <script type="text/javascript">
	jQuery(document).ready(function($) {
  	  $(".comment-click-'.$post->ID.'").on("click", function(){
  	    $(".com-click-id-'.$post->ID.'").show();
	    $(".disqus-thread-'.$post->ID.'").show();
  	    $(".com-but-'.$post->ID.'").hide();
	  });
	});
    </script>';
}
}

/////////////////////////////////////
// Related Posts
/////////////////////////////////////

if ( !function_exists( 'mvp_RelatedPosts' ) ) {
function mvp_RelatedPosts() {
    global $post;
    $orig_post = $post;

    $tags = wp_get_post_tags($post->ID);
    if ($tags) {

	$mvp_related_num = esc_html(get_option('mvp_related_num'));
	$slider_exclude = esc_html(get_option('mvp_feat_posts_tags'));
	$tag_exclude_slider = get_term_by('slug', $slider_exclude, 'post_tag');
	if (!empty( $tag_exclude_slider )) {
		$tag_id_exclude_slider =  $tag_exclude_slider->term_id;
       		$tag_ids = array();
        	foreach($tags as $individual_tag) {
			$excluded_tags = array($tag_id_exclude_slider);
      			if (in_array($individual_tag->term_id,$excluded_tags)) continue;
 			$tag_ids[] = $individual_tag->term_id;
		}
	} else {
       		$tag_ids = array();
        	foreach($tags as $individual_tag) $tag_ids[] = $individual_tag->term_id;
	}
        $args=array(
            'tag__in' => $tag_ids,
	    'order' => 'DESC',
	    'orderby' => 'date',
            'post__not_in' => array($post->ID),
            'posts_per_page'=> $mvp_related_num,
            'ignore_sticky_posts'=> 1
        );
        $my_query = new WP_Query( $args );
        if( $my_query->have_posts() ) { ?>
				<ul class="mvp-related-posts-list left related">
            		<?php while( $my_query->have_posts() ) { $my_query->the_post(); ?>
						<a href="<?php the_permalink(); ?>" rel="bookmark">
            			<li>
							<?php if (  (function_exists('has_post_thumbnail')) && (has_post_thumbnail())  ) { ?>
                				<div class="mvp-related-img left relative">
									<?php the_post_thumbnail('mvp-mid-thumb', array( 'class' => 'mvp-reg-img' )); ?>
									<?php the_post_thumbnail('mvp-small-thumb', array( 'class' => 'mvp-mob-img' )); ?>
									<?php if ( has_post_format( 'video' )) { ?>
										<div class="mvp-vid-box-wrap mvp-vid-box-mid mvp-vid-marg">
											<i class="fa fa-2 fa-play" aria-hidden="true"></i>
										</div><!--mvp-vid-box-wrap-->
									<?php } else if ( has_post_format( 'gallery' )) { ?>
										<div class="mvp-vid-box-wrap mvp-vid-box-mid">
											<i class="fa fa-2 fa-camera" aria-hidden="true"></i>
										</div><!--mvp-vid-box-wrap-->
									<?php } ?>
								</div><!--mvp-related-img-->
							<?php } ?>
							<div class="mvp-related-text left relative">
								<p><?php the_title(); ?></p>
							</div><!--mvp-related-text-->
            			</li>
						</a>
            		<?php }
            echo '</ul>';
        }
    }
    $post = $orig_post;
    wp_reset_query();
}
}

/////////////////////////////////////
// Popular Posts
/////////////////////////////////////

if ( !function_exists( 'getCrunchifyPostViews' ) ) {
function getCrunchifyPostViews($postID){
    $count_key = 'post_views_count';
    $count = get_post_meta($postID, $count_key, true);
    if($count==''){
        delete_post_meta($postID, $count_key);
        add_post_meta($postID, $count_key, '0');
        return "0 View";
    }
    return $count.' Views';
}
}

if ( !function_exists( 'setCrunchifyPostViews' ) ) {
function setCrunchifyPostViews($postID) {
    $count_key = 'post_views_count';
    $count = get_post_meta($postID, $count_key, true);
    if($count==''){
        $count = 0;
        delete_post_meta($postID, $count_key);
        add_post_meta($postID, $count_key, '0');
    }else{
        $count++;
        update_post_meta($postID, $count_key, $count);
    }
}
}

if ( !function_exists( 'mvp_post_views' ) ) {
function mvp_post_views(){
	$post_id = get_the_ID();
	$count_key = 'post_views_count';
	$n = get_post_meta($post_id, $count_key, true);
	if ($n > 999999999) {
		$n_format = number_format($n / 1000000000, 1) . 'B';
	} else if ($n > 999999) {
		$n_format = number_format($n / 1000000, 1) . 'M';
	} else if ($n > 999) {
        	$n_format = number_format($n / 1000, 1) . 'K';
	} else {
		$n_format = $n;
   	}

	echo $n_format;
}
}

/////////////////////////////////////
// Pagination
/////////////////////////////////////

if ( !function_exists( 'pagination' ) ) {
function pagination($pages = '', $range = 4)
{
     $showitems = ($range * 2)+1;

     global $paged;
     if(empty($paged)) $paged = 1;

     if($pages == '')
     {
         global $wp_query;
         $pages = $wp_query->max_num_pages;
         if(!$pages)
         {
             $pages = 1;
         }
     }

     if(1 != $pages)
     {
         echo "<div class=\"pagination\"><span>".__( 'Page', 'zox-news' )." ".$paged." ".__( 'of', 'zox-news' )." ".$pages."</span>";
         if($paged > 2 && $paged > $range+1 && $showitems < $pages) echo "<a href='".get_pagenum_link(1)."'>&laquo; ".__( 'First', 'zox-news' )."</a>";
         if($paged > 1 && $showitems < $pages) echo "<a href='".get_pagenum_link($paged - 1)."'>&lsaquo; ".__( 'Previous', 'zox-news' )."</a>";

         for ($i=1; $i <= $pages; $i++)
         {
             if (1 != $pages &&( !($i >= $paged+$range+1 || $i <= $paged-$range-1) || $pages <= $showitems ))
             {
                 echo ($paged == $i)? "<span class=\"current\">".$i."</span>":"<a href='".get_pagenum_link($i)."' class=\"inactive\">".$i."</a>";
             }
         }

         if ($paged < $pages && $showitems < $pages) echo "<a href=\"".get_pagenum_link($paged + 1)."\">".__( 'Next', 'zox-news' )." &rsaquo;</a>";
         if ($paged < $pages-1 &&  $paged+$range-1 < $pages && $showitems < $pages) echo "<a href='".get_pagenum_link($pages)."'>".__( 'Last', 'zox-news' )." &raquo;</a>";
         echo "</div>\n";
     }
}
}

/////////////////////////////////////
// Disqus Comments
/////////////////////////////////////

$disqus_id = get_option('mvp_disqus_id'); if (isset($disqus_id)) {
if ( !function_exists( 'mvp_disqus_embed' ) ) {
function mvp_disqus_embed($disqus_shortname) {
    global $post;
    wp_enqueue_script('disqus_embed','//'.$disqus_shortname.'.disqus.com/embed.js');
    echo '<div id="disqus_thread" class="disqus-thread-'.$post->ID.'"></div>
    <script type="text/javascript">
        var disqus_shortname = "'.$disqus_shortname.'";
        var disqus_title = "'.$post->post_title.'";
        var disqus_url = "'.get_permalink($post->ID).'";
        var disqus_identifier = "'.$disqus_shortname.'-'.$post->ID.'";
    </script>';
}
}
}

/////////////////////////////////////
// Remove Pages From Search Results
/////////////////////////////////////

if ( !is_admin() ) {

function mvp_SearchFilter($query) {
if ($query->is_search) {
$query->set('post_type', 'post');
}
return $query;
}

add_filter('pre_get_posts','mvp_SearchFilter');

}

/////////////////////////////////////
// Miscellaneous
/////////////////////////////////////

// Place Wordpress Admin Bar Above Main Navigation

if ( is_user_logged_in() ) {
	if ( is_admin_bar_showing() ) {
	function mvp_admin_bar() {
		echo "
			<style type='text/css'>
			#mvp-leader-wrap {top: 32px;}
			.mvp-nav-small, .mvp-fixed1, .mvp-nav-small-fixed {top: -38px !important;}
			</style>
		";
	}
	add_action( 'wp_head', 'mvp_admin_bar' );
	}
}

// Set Content Width
if ( ! isset( $content_width ) ) $content_width = 740;

// Add RSS links to <head> section
add_theme_support( 'automatic-feed-links' );

add_action('init', 'do_output_buffer');
function do_output_buffer() {
        ob_start();
}

/////////////////////////////////////
// WooCommerce
/////////////////////////////////////

add_theme_support( 'woocommerce' );
add_theme_support( 'wc-product-gallery-zoom' );
add_theme_support( 'wc-product-gallery-lightbox' );
add_theme_support( 'wc-product-gallery-slider' );

add_action( 'wp_enqueue_scripts', 'agentwp_dequeue_stylesandscripts', 100 );

function agentwp_dequeue_stylesandscripts() {
    if ( class_exists( 'woocommerce' ) ) {
    wp_dequeue_style( 'selectWoo' );
    wp_deregister_style( 'selectWoo' );

    wp_dequeue_script( 'selectWoo');
    wp_deregister_script('selectWoo');

   }
}

?>